package com.macrofocus.common.timer

class SwingTimer : AbstractCPTimer {
    private val name: String?
    private var timer: CoalescingTimer
    private var keepAliveTimer: CoalescingTimer?
    private var timerThread: Thread? = null
    private var keepAliveThread: Thread? = null

    constructor(name: String?, delay: Int, postponing: Boolean) {
        this.name = name
        timer = CoalescingTimer(delay, postponing)
        keepAliveTimer = null
        timer.addActionListener(object : Timer.TimerListener {
            override fun timerTriggered() {
                for (listener in listeners) {
                    listener.timerTriggered()
                }
            }
        })
    }

    constructor(name: String?, delay: Int, keepAlive: Int, postponing: Boolean) {
        this.name = name
        assert(keepAlive > delay)
        timer = CoalescingTimer(delay, postponing)
        keepAliveTimer = CoalescingTimer(keepAlive)
        timer.addActionListener(object : Timer.TimerListener {
            override fun timerTriggered() {
                for (listener in listeners) {
                    listener.timerTriggered()
                }
            }
        })
        keepAliveTimer!!.addActionListener(object : Timer.TimerListener {
            override fun timerTriggered() {
                timer.stop()
                keepAliveTimer!!.stop()
                keepAliveThread = null
                timerThread = null
            }
        })
    }

    override fun restart() {
        if (timerThread == null || !timerThread!!.isAlive) {
            timerThread = Thread(timer)
            timerThread!!.name = if (name != null) "$name\$Timer" else "Coalescing\$Timer"
            timerThread!!.isDaemon = true
            timerThread!!.start()
        }
        if (keepAliveTimer != null && keepAliveThread == null || !keepAliveThread!!.isAlive) {
            keepAliveThread = Thread(keepAliveTimer)
            keepAliveThread!!.name = if (name != null) "$name\$KeepAlive" else "Coalescing\$KeepAlive"
            keepAliveThread!!.isDaemon = true
            keepAliveThread!!.start()
        }
        timer.restart()
        if (keepAliveTimer != null) {
            keepAliveTimer!!.restart()
        }
    }

    fun stop() {
        timer.stop()
        if (keepAliveTimer != null) {
            keepAliveTimer!!.stop()
        }
    }

    override fun toString(): String {
        return "SwingTimer{" +
                "timer=" + timer +
                "timerThread=" + (timerThread != null && timerThread!!.isAlive) +
                "keepAliveThread=" + (keepAliveThread != null && keepAliveThread!!.isAlive) +
                '}'
    }
}
