package com.macrofocus.common.collection

class ObjectIntMap<K> {
    private val map: HashMap<K, Int>
    private val noEntryValue: Int

    constructor(initialCapacity: Int, noEntryValue: Int) {
        this.noEntryValue = noEntryValue
        map = HashMap<K, Int>(initialCapacity)
    }

    constructor(map: HashMap<K, Int>, noEntryValue: Int) {
        this.map = map
        this.noEntryValue = noEntryValue
    }

    fun clear() {
        map.clear()
    }

    fun containsKey(key: K): Boolean {
        return map.containsKey(key)
    }

    fun containsValue(value: Int): Boolean {
        return map.containsValue(value)
    }

    operator fun get(key: K): Int {
        val value: Int? = map.get(key)
        return value ?: noEntryValue
    }

    val isEmpty: Boolean
        get() = map.isEmpty()

    fun put(key: K, value: Int): Int {
        val put: Int? = map.put(key, value)
        return put ?: noEntryValue
    }

    fun remove(key: K): Int {
        return map.remove(key)!!
    }

    fun size(): Int {
        return map.size
    }

    fun adjustOrPutValue(key: K, adjust_amount: Int, put_amount: Int): Int {
        return if (map.containsKey(key)) {
            val value: Int = map.get(key)!!
            val adjustedValue = value + adjust_amount
            map.put(key, adjustedValue)
            adjustedValue
        } else {
            map.put(key, put_amount)
            put_amount
        }
    }

    fun adjustValue(key: K, amount: Int): Boolean {
        return if (map.containsKey(key)) {
            val value: Int = map.get(key)!!
            map.put(key, value + amount)
            true
        } else {
            false
        }
    }

    fun copy(vararg keysToRemove: K): ObjectIntMap<K> {
        val map: ObjectIntMap<K> = ObjectIntMap<K>(HashMap<K, Int>(map), noEntryValue)
        for (k in keysToRemove) {
            map.remove(k)
        }
        return map
    }
}
