/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.filter

import com.macrofocus.common.collection.Iterables.nonNull

abstract class AbstractFilterCoordinator<A, B> constructor(a: MutableFilter<A>, b: MutableFilter<B>) {
    private val a: MutableFilter<A>
    private val b: MutableFilter<B>
    private var updatingFilter: Boolean = false
    val a2bListener: FilterListener<A> = object : FilterListener<A> {
        override fun filterChanged(event: FilterEvent<A>) {
            if (!updatingFilter) {
                updatingFilter = true
                val filtered: Iterable<B> = nonNull(object : Iterable<B> {
                    public override fun iterator(): Iterator<B> {
                        return object : Iterator<B> {
                            var it: Iterator<A> = event.filtered.iterator()
                            public override fun hasNext(): Boolean {
                                return it.hasNext()
                            }

                            public override fun next(): B {
                                val a: A = it.next()
                                return a2b(a)
                            }
                        }
                    }
                })
                val unfiltered: Iterable<B> = nonNull(object : Iterable<B> {
                    public override fun iterator(): Iterator<B> {
                        return object : Iterator<B> {
                            var it: Iterator<A> = event.unfiltered.iterator()
                            public override fun hasNext(): Boolean {
                                return it.hasNext()
                            }

                            public override fun next(): B {
                                val a: A = it.next()
                                return a2b(a)
                            }
                        }
                    }
                })
                b.setFilteredState(filtered, unfiltered, a)
                updatingFilter = false
            }
        }
    }
    val b2aListener: FilterListener<B> = object : FilterListener<B> {
        override fun filterChanged(event: FilterEvent<B>) {
            if (!updatingFilter) {
                updatingFilter = true
                val filtered: Iterable<A> = nonNull(object : Iterable<A> {
                    public override fun iterator(): Iterator<A> {
                        return object : Iterator<A> {
                            var it: Iterator<B> = event.filtered.iterator()
                            public override fun hasNext(): Boolean {
                                return it.hasNext()
                            }

                            public override fun next(): A {
                                val b: B = it.next()
                                return b2a(b)
                            }
                        }
                    }
                })
                val unfiltered: Iterable<A> = nonNull(object : Iterable<A> {
                    public override fun iterator(): Iterator<A> {
                        return object : Iterator<A> {
                            var it: Iterator<B> = event.unfiltered.iterator()
                            public override fun hasNext(): Boolean {
                                return it.hasNext()
                            }

                            public override fun next(): A {
                                val b: B = it.next()
                                return b2a(b)
                            }
                        }
                    }
                })
                a.setFilteredState(filtered, unfiltered, b)
                updatingFilter = false
            }
        }
    }

    abstract fun a2b(b: A): B
    abstract fun b2a(a: B): A

    init {
        this.a = a
        this.b = b
        a.addFilterListener(a2bListener)
        b.addFilterListener(b2aListener)
    }
}