package com.macrofocus.common.properties

/**
 * Default data model a property.
 *
 * @param <T> the type of elements that the property can hold
</T> */
class SimpleListProperty<T>(value: Array<T>) : AbstractMutableListProperty<T>(), MutableListProperty<T> {
    private var list: MutableList<T> = ArrayList<T>(value.asList())

    override var value: List<out T>?
        get() = ArrayList(list)
        set(value) {
//        if(this.value != value) {
            val old = list
            if(value != null) {
                list = ArrayList<T>(value)
            } else {
                list = ArrayList<T>()
            }
            notifyPropertyChanged(PropertyEvent<List<out T>?>(old, value))
            //        }
        }

    override fun append(value: T) {
        val old = this.value
        this.list.add(value)
        val present = this.value
        notifyPropertyChanged(PropertyEvent<List<T>?>(old, present))
    }

    override fun toString(): String {
        return "SimpleListProperty{" +
                "value=" + value +
                '}'
    }

    companion object {
        fun <T> newInstance(value: Array<T>): SimpleListProperty<T> {
            return SimpleListProperty(value)
        }
    }
}
