/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.selection

/**
 * Default implementation of a SelectionEvent.
 */
data class SimpleSelectionEvent<E>(override val model: Selection<E>, val changes: Set<E>) : AbstractSelectionEvent<E>() {
    override fun isAffected(element: E): Boolean {
        return changes.contains(element)
    }

    override val affected: Iterable<E>
        get() = changes

    override fun toString(): String {
        var s = "SimpleSelectionEvent{" +
                "model=" + model +
                ", changes="
        for (change in changes) {
            s += change.toString() + "(" + model.isSelected(change) + "),"
        }
        s += '}'
        return s
    }
}