package com.macrofocus.common.crossplatform

import com.macrofocus.common.concurrent.ExecutorService
import com.macrofocus.common.timer.CPTimer
import com.macrofocus.common.timer.CPTimerListener
import kotlin.reflect.KClass

/**
 * Created by luc on 30.04.17.
 */
expect class CPHelper {
    companion object {
        val instance : CPHelper
    }

    fun newFixedThreadPool(name: String, corePoolSize: Int, maximumPoolSize: Int): ExecutorService?
    fun visualizationExecutorService(): ExecutorService?
    fun createTimer(name: String, delay: Int, postponing: Boolean): CPTimer
    fun createTimer(name: String, delay: Int, postponing: Boolean, timerListener: CPTimerListener): CPTimer

    /**
     * Causes the currently executing thread to sleep (temporarily cease
     * execution) for the specified number of milliseconds, subject to
     * the precision and accuracy of system timers and schedulers. The thread
     * does not lose ownership of any monitors.
     *
     * @param  millis
     * the length of time to sleep in milliseconds
     *
     * @throws  IllegalArgumentException
     * if the value of `millis` is negative
     *
     * @throws  InterruptedException
     * if any thread has interrupted the current thread. The
     * *interrupted status* of the current thread is
     * cleared when this exception is thrown.
     */
    fun sleep(millis: Long)
    fun isAssignableFrom(a: KClass<*>, b: KClass<*>): Boolean
    fun isNumericType(cl: KClass<*>): Boolean
    fun isTemporalType(cl: KClass<*>): Boolean
    fun isVisualType(cl: KClass<*>): Boolean
    fun isArray(cl: KClass<*>): Boolean
    val isMac : Boolean

    /** Current UNIX time in millis */
    val currentTimeMillis: Long
}
