package com.macrofocus.common.math

const val DEGREES_TO_RADIANS = 0.017453292519943295
const val RADIANS_TO_DEGREES = 57.29577951308232

//fun Double.convertDegreesToRadians(): Double = this * DEGREES_TO_RADIANS
//
//fun Double.convertRadiansToDegrees(): Double = this * RADIANS_TO_DEGREES

fun convertDegreesToRadians(angdeg: Double) : Double {
    return angdeg * DEGREES_TO_RADIANS
}

fun convertRadiansToDegrees(angdeg: Double) : Double {
    return angdeg * RADIANS_TO_DEGREES
}

fun isNaN(value: Double) : Boolean {
    return value.isNaN()
}

fun isInfinite(value: Double) : Boolean {
    return value.isInfinite()
}

fun isNaN(value: Float) : Boolean {
    return value.isNaN()
}

fun isInfinite(value: Float) : Boolean {
    return value.isInfinite()
}

fun doubleToLongBits(value: Double) : Long {
    return value.toRawBits()
}

fun compare(v1: Double, v2 : Double) : Int {
    return v1.compareTo(v2)
}