/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.selection

/**
 * An event that characterizes a change in the current selection.
 *
 * @param <E>
</E> */
interface SelectionEvent<E> {
    val model: Selection<E>
    fun isAffected(element: E): Boolean
    val affected: Iterable<E>
    val selected: Iterable<E>
    val unselected: Iterable<E>
}