package com.macrofocus.common.interval

import com.macrofocus.common.properties.Property

/**
 * / ** This interface represents the current state of an interval.
 */
expect interface Interval {
    val startProperty: Property<Double>
    val endProperty: Property<Double>

    val start: Double

    val end: Double

    val extent: Double

    /**
     * Tests if this interval contains the specified value
     *
     * @param value the value to test
     * @return true if the interval contains the value, false otherwise
     */
    operator fun contains(value: Double): Boolean

    /**
     * Tests if this interval contains the specified interval
     *
     * @param start the value to test
     * @param end the value to test
     * @return true if the interval contains the value, false otherwise
     */
    fun containsStartEnd(start: Double, end: Double): Boolean

    /**
     * Tests if this interval contains the specified interval
     *
     * @param interval the interval to test
     * @return true if the interval contains the value, false otherwise
     */
    fun containsInterval(interval: Interval?): Boolean

    /**
     * Tests if this interval overlaps the specified interval.
     *
     * @param start the interval to test
     * @param end the interval to test
     * @return true if this interval overlaps the specified interval, false otherwise
     */
    fun overlaps(start: Double, end: Double): Boolean

    /**
     * Tests if this interval overlaps the specified interval.
     *
     * @param interval the interval to test
     * @return true if this interval overlaps the specified interval, false otherwise
     */
    fun overlapsInterval(interval: Interval?): Boolean

    /**
     * Tests whether the starting and ending values are the same
     *
     * @return true if start and end values are identical, false otherwise
     */
    val isDegenerate: Boolean
    val isInverted: Boolean

    fun addIntervalListener(listener: IntervalListener)
    fun addWeakIntervalListener(listener: IntervalListener)
    fun removeIntervalListener(listener: IntervalListener)
    fun removeIntervalListeners()
}