package com.macrofocus.common.logging

class Logging private constructor() {
    private var outputs: Array<out LoggingOutput>
    fun process(t: Throwable?): Boolean {
        var r = false
        for (output in outputs) {
            try {
                r = r or output.process(t)
            } catch (e: Throwable) {
                e.printStackTrace()
            }
        }
        return r
    }

    fun setOutput(vararg output: LoggingOutput) {
        outputs = output
    }

    companion object {
        val instance = Logging()
    }

    init {
        outputs = arrayOf<LoggingOutput>(StderrLoggingOutput())
    }
}