package com.macrofocus.license

/**
 * Validity.Product &amp; ExpirationDateType.CurrentDate: Valid for a specific product, as long as the expiration date is in the future (evaluation licensing)
 * Validity.ProductMajorVersionNumber &amp; Expiration.CurrentDate: Valid for a specific version of a product, as long as the expiration date is in the future (old licensing scheme)
 * Validity.Product &amp; ExpirationDateType.Expiration: Valid for a specific product, as long as the expiration date is in the future (standard licensing)
 * Validity.ProductMajorVersionNumber &amp; Expiration.ReleaseDate: Valid for a specific version of a product, as long as the release date is in the future (unused)
 */
interface LicenseModel {
    fun verify(): State?
    val username: String?

//    val expirationDate: java.util.Date?
    val expiration: Expiration?
    val validity: Validity?

    enum class State(private val toString: String) {
        Valid("License key is valid"), InvalidLength("License key has an invalid length"), InvalidKey("License key is not valid"), EmptyUsername(
            "License has an empty username"
        ),
        EmptyKey("License key is empty"), Expired("License key has expired");

        override fun toString(): String {
            return toString
        }
    }

    enum class Expiration {
        CurrentDate, ReleaseDate
    }

    enum class Validity {
        Product, ProductMajorVersionNumber
    }
}
