package com.macrofocus.common.properties

/**
 * Unidirectional binding
 */
fun <T> MutableProperty<T>.bind(set: (value: T) -> Unit) {
    var updating = false

    val listener = object : PropertyListener<T> {
        private val lock = set // Keep a reference to the component so that it is not garbage collected

        override fun propertyChanged(event: PropertyEvent<T>) {
            if(!updating) {
                updating = true
                set(event.newValue)
                updating = false
            }
        }
    }

    addWeakPropertyListener(listener)

    set(value)
}
