package com.macrofocus.common.units

import com.macrofocus.common.math.RADIANS_TO_DEGREES

open class Angle(name: String, symbol: String, ratio: Double) : Unit(name, symbol, ratio) {
    companion object Factory {
        val Degree = Angle("Degree", "°", 1.0)
        val Radian = Angle("Radian", "rad", RADIANS_TO_DEGREES)
    }
}

val Number.Degree: Quantity<Angle> get() = Quantity(this.toDouble(), Angle.Degree)
val Number.Radian: Quantity<Angle> get() = Quantity(this.toDouble(), Angle.Radian)
