package com.macrofocus.common.interval

/**
 * Defines the requirements for an interval that is bounded between two values.
 */
interface BoundedInterval : Interval {
    val minimum: Double
    val maximum: Double
    val minimumExtent: Double
    val maximumExtent: Double
    val isFullRange: Boolean

    fun addBoundedIntervalListener(listener: BoundedIntervalListener)
    fun addWeakBoundedIntervalListener(listener: BoundedIntervalListener)
    fun removeBoundedIntervalListener(listener: BoundedIntervalListener)
    fun removeBoundedIntervalListeners()
    val isInvertedScale: Boolean
}
