package com.macrofocus.common.interval

/**
 * An open interval is an interval that does not include its end points.
 */
class OpenInterval(start: Double, extent: Double) : PropertyClosedInterval(start, extent) {
    override fun contains(value: Double): Boolean {
        return start <= value && end >= value
    }
}