package com.macrofocus.common.properties

/**
 * All equality test are performed using O (use case are JsDate that don't support equality comparison)
 */
class OTransformedProperty<O, T>(val original: MutableProperty<O>, val forward: (O) -> T, val backward: (T) -> O) :
    AbstractMutableProperty<T>() {
    private val DEBUG = true
    private var guard = false

    private val listener = object : PropertyListener<O> {
        override fun propertyChanged(event: PropertyEvent<O>) {
            val oldValueO : O = event.oldValue
            val newValueO : O = event.newValue
            val changeO = oldValueO != newValueO
            if(changeO) {
                // This will go into an infinite loop!
                val oldValueT : T = forward.invoke(oldValueO) // value
                val newValueT : T = forward.invoke(newValueO)
                if(DEBUG) println("OTransformedProperty changed: $oldValueT,$newValueT -> $changeO, value=$value")
                value = newValueT
                notifyPropertyChanged(PropertyEvent(oldValueT, newValueT))
            }
        }
    }

    init {
        original.addPropertyListener(listener)
    }

    override var value: T = forward.invoke(original.value)
        set(newValueT) {
            val oldValueT : T = field
            val changeT = oldValueT != newValueT
            if(DEBUG) println("OTransformedProperty set: $oldValueT,$newValueT -> $changeT")
            val oldValueO : O = backward.invoke(oldValueT)
            val newValueO : O = backward.invoke(newValueT)
            val changeO = oldValueO != newValueO
            if(DEBUG) println("OTransformedProperty apply: $oldValueO,$newValueO -> $changeO")
            if (changeO) {
                field = newValueT
                original.value = newValueO
            }
        }
}