package com.macrofocus.common.properties

import com.macrofocus.common.collection.Iterables.nonNull
import com.macrofocus.common.selection.MutableSelection
import com.macrofocus.common.selection.SelectionEvent
import com.macrofocus.common.selection.SelectionListener

abstract class AbstractSelectionCoordinator<A, B>(
    private val a: MutableSelection<A>,
    private val b: MutableSelection<B>
) {
    private var updatingSelection = false
    val a2bListener: SelectionListener<A> = object : SelectionListener<A> {
        override fun selectionChanged(event: SelectionEvent<A>) {
            if (!updatingSelection) {
                updatingSelection = true
                b.setSelectedIterable(nonNull(object : Iterable<B> {
                    override fun iterator(): Iterator<B> {
                        return object : Iterator<B> {
                            var it = event.model.iterator()
                            override fun hasNext(): Boolean {
                                return it.hasNext()
                            }

                            override fun next(): B {
                                val a = it.next()
                                return a2b(a)
                            }
                        }
                    }
                }))
                updatingSelection = false
            }
        }
    }
    val b2aListener: SelectionListener<B> = object : SelectionListener<B> {
        override fun selectionChanged(event: SelectionEvent<B>) {
            if (!updatingSelection) {
                updatingSelection = true
                a.setSelectedIterable(nonNull(object : Iterable<A> {
                    override fun iterator(): Iterator<A> {
                        return object : Iterator<A> {
                            var it = event.model.iterator()
                            override fun hasNext(): Boolean {
                                return it.hasNext()
                            }

                            override fun next(): A {
                                val b = it.next()
                                return b2a(b)
                            }
                        }
                    }
                }))
                updatingSelection = false
            }
        }
    }

    abstract fun a2b(b: A): B
    abstract fun b2a(a: B): A

    init {
        a.addSelectionListener(a2bListener)
        b.addSelectionListener(b2aListener)
    }
}