package com.macrofocus.common.transform

import com.macrofocus.common.interval.Interval

/**
 * This interface represents transform from world to screen coordinates, and vice-versa.
 */
interface OneDScreenTransform {
    fun screenToWorld(screen: Int): Double
    fun worldToScreen(world: Double): Int
    fun worldToScreenPrecise(world: Double): Double
    val worldInterval: Interval
    val screenSize: Int
    val isAffine: Boolean
    val worldMin: Double
    val worldMax: Double
    val worldRange: Double
    val isWorldCoordinatesInverted: Boolean

    fun addScreenTransformListener(listener: ScreenTransformListener)
    fun addWeakScreenTransformListener(listener: ScreenTransformListener)
    fun removeScreenTransformListener(listener: ScreenTransformListener)
    fun removeScreenTransformListeners()
}