package com.macrofocus.dom

fun xml(
    root: String,
    namespace: String?,
    vararg args: Pair<String?, Any?>?,
    block: Builder.() -> Unit = {}
): Definition {
    return Definition.build(namespace) {
        root.invoke(*args, block=block)
    }
}

fun xml(root: String, block: Builder.() -> Unit = {}) = xml(root, namespace=null, args= arrayOf(), block = block)
fun xml(root: String, vararg  args: Pair<String?, Any?>?, block: Builder.() -> Unit = {}) = xml(root, namespace=null, args=args, block = block)

fun svg(
    width: Int?,
    height: Int?,
    viewBoxX: Double? = null,
    viewBoxY: Double? = null,
    viewBoxWidth: Double? = null,
    viewBoxHeight: Double? = null,
    block: Builder.() -> Unit = {}
): Definition {
    return Definition.build("http://www.w3.org/2000/svg") {
        "svg"(
            "xmlns" to "http://www.w3.org/2000/svg",
            "version" to "1.1",
            "width" to width?.toString(),
            "height" to height?.toString(),
            if (viewBoxX != null && viewBoxY != null && viewBoxWidth != null && viewBoxHeight != null) "viewBox" to "$viewBoxX $viewBoxY $viewBoxWidth $viewBoxHeight" else null,
            block = block
        )
    }
}

fun html(
    root: String,
    vararg args: Pair<String?, Any?>?,
    block: Builder.() -> Unit = {}
): Definition {
    return Definition.build("http://www.w3.org/1999/xhtml") {
        root.invoke(*args, block=block)
    }
}