/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.collection

object Arrays {
    fun toString(a: Array<Any?>?): String? {
        if (a == null) return "null"
        val iMax = a.size - 1
        if (iMax == -1) return "[]"
        val b: StringBuilder = StringBuilder()
        b.append('[')
        var i = 0
        while (true) {
            b.append(a[i].toString())
            if (i == iMax) return b.append(']').toString()
            b.append(", ")
            i++
        }
    }
}