/*
 * Copyright (c) 2013 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.hierarchy

internal class LeavesEnumeration<T>(private val hierarchy: Hierarchy<T>, rootNode: T) : MutableIterator<T> {
    protected var current: T?
    override fun hasNext(): Boolean {
        return current != null
    }

    override fun next(): T {
        val previous = current
        current = hierarchy.getNextLeaf(current!!)
        return previous!!
    }

    override fun remove() {
        throw UnsupportedOperationException()
    }

    init {
        current = hierarchy.getFirstLeaf(rootNode)
    }
}