package com.macrofocus.common.format

interface CPFormat<T> {
    fun format(value: T): String?
    fun formatHtml(value: T, htmlSupported: Boolean): String?

    fun parse(text: String?): T
    val pattern: String?
    val nativeFormat: Any?
    val horizontalAlignment: HorizontalAlignment?

    fun getClassName(value: T): String?
    enum class HorizontalAlignment {
        Left, Center, Right
    }

    class ParsingException : Exception {
        /**
         * Returns the position where the error was found.
         *
         * @return the position where the error was found
         */
        /**
         * The zero-based character offset into the string being parsed at which
         * the error was found during parsing.
         * @serial
         */
        var errorOffset = 0
            private set

        constructor() {}

        /**
         * Constructs a ParsingException with the specified detail message and
         * offset.
         * A detail message is a String that describes this particular exception.
         *
         * @param s the detail message
         * @param errorOffset the position where the error is found while parsing.
         */
        constructor(s: String?, errorOffset: Int) : super(s) {
            this.errorOffset = errorOffset
        }

        companion object {
            private const val serialVersionUID = 2703218443322787634L
        }
    }
}
