package com.macrofocus.common.properties

/**
 * Default data model a property.
 *
 * @param <T> the type of elements that the property can hold
</T> */
class SimpleArrayProperty<T>(value: Array<T>) : AbstractMutableProperty<Array<T>>(), MutableProperty<Array<T>> {
    private var array = value.copyOf()

    override var value: Array<T>
        get() = array
        set(value) {
            if(this.value !== value) {
                val old = array.copyOf()
//                if(value != null) {
                    array = value
//                } else {
//                    array = emptyArray()
//                }
                notifyPropertyChanged(PropertyEvent<Array<T>>(old, value))
            }
        }

    val size: Int
        get() = array.size

    fun add(index: Int, element: T) {
        val old = array.copyOf()
        this.array = this.array.copyOfRange(0, index) + element + this.array.copyOfRange(index, this.array.size)
        val present = this.value
        notifyPropertyChanged(PropertyEvent<Array<T>>(old, present))
    }

    fun append(value: T) {
        val old = array.copyOf()
        this.array += value
        val present = this.value
        notifyPropertyChanged(PropertyEvent<Array<T>>(old, present))
    }

    fun removeAt(index: Int): T {
        val old = array.copyOf()
        this.array = this.array.copyOfRange(0, index) + this.array.copyOfRange(index + 1, array.size)
        val present = this.value
        notifyPropertyChanged(PropertyEvent<Array<T>>(old, present))

        return old[index]
    }

    operator fun set(index: Int, value: T) {
        if(array[index] !== value) {
            val old = array
            val new = array.copyOf()
            new[index] = value
            array = new
            val present = this.value
            notifyPropertyChanged(PropertyEvent<Array<T>>(old, present))
        }
    }

    fun contains(value: T) : Boolean {
        return array.contains(value)
    }

    operator fun get(index: Int) : T {
        return array[index]
    }

    fun indexOf(value: T) : Int {
        return array.indexOf(value)
    }

    override fun toString(): String {
        return "SimpleArrayProperty{" +
                "value=" + value +
                '}'
    }

    companion object {
        fun <T> newInstance(value: Array<T>): SimpleArrayProperty<T> {
            return SimpleArrayProperty(value)
        }
    }
}
