/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking

/**
 * User: luc
 * Date: May 31, 2006
 * Time: 10:01:41 PM
 */
open class NakedDockable<C> constructor(override val component: C, override val title: String, override val iconURL: String? = null) : Dockable<C> {
    override var container: C? = null
    override final val shortTitle: String
    override var dockingBar: DockingBar<C>? = null
    override val description: String? = null

    override fun attachContainer() {}
    override fun detachContainer(): C? {
        return container
    }

    override fun dispose() {
        container = null
    }

    init {
        container = component
        shortTitle = title
    }
}