package com.macrofocus.docking.compose

import androidx.compose.material.Button
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import com.macrofocus.common.command.Command
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.SimpleProperty
import com.macrofocus.docking.DockingAnchor
import org.mkui.color.colorOf
import org.mkui.component.CPComponent
import org.mkui.compose.toState

class DockingButton(orientation: DockingAnchor, command: MutableProperty<Command?> = SimpleProperty(null), private val textProperty: MutableProperty<String?> = SimpleProperty("")) : CPComponent {
    val selectedProperty : MutableProperty<Boolean> = SimpleProperty(false)

    var text by textProperty
    var command by command
    var selected by selectedProperty

    override val nativeComponent:  @Composable () -> Unit = {
        val text by textProperty.toState()
        val (getSelected, _) = selectedProperty.toState()

        Button(onClick = { command.value?.execute() }) {
            if(text != null) {
                Text(text!!)
            }
        }
    }
}