package com.macrofocus.docking.compose

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.size
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.SimpleProperty
import com.macrofocus.docking.*
import com.macrofocus.docking.js.splitter.CPThreeComponentsSplitter
import com.macrofocus.docking.splitter.ThreeComponentsSplitter
import org.mkui.component.CPComponent
import org.mkui.compose.ComposeComponent
import org.mkui.compose.toState

class ComposeDockingPanel(private var vertical: Boolean = true) : DockingPanel<CPComponent> {
    val center : MutableProperty<CPComponent?> = SimpleProperty<CPComponent?>(null)

    val westContainerPanel: DockingContainer = DockingContainer()
    val eastContainerPanel: DockingContainer = DockingContainer()
    val southContainerPanel: DockingContainer = DockingContainer()
    val northContainerPanel: DockingContainer = DockingContainer()

    override val nativeComponent: CPComponent = ComposeComponent( {
        val (getCenter, _) = center.toState()

        Box(
            modifier = Modifier
                .fillMaxSize()
                .background(Color.Gray)
        ) {
            Box(
                modifier = Modifier
                    .background(Color.Yellow)
                    .align(Alignment.TopStart)
                    .size(50.dp, 50.dp)
            ) {
                ComposeDockingCorner().nativeComponent()
            }
            Box(
                modifier = Modifier
                    .background(Color.Red)
                    .align(Alignment.TopCenter)
                    .size(50.dp, 50.dp)
            ) {
                northDockingBar.nativeComponent.nativeComponent()
            }
            Box(
                modifier = Modifier
                    .background(Color.Green)
                    .align(Alignment.TopEnd)
                    .size(50.dp, 50.dp)
            ) {
                ComposeDockingCorner().nativeComponent()
            }
            Box(
                modifier = Modifier
                    .background(Color.Blue)
                    .align(Alignment.CenterStart)
                    .size(50.dp, 50.dp)
            ) {
                westDockingBar.nativeComponent.nativeComponent()
            }
            if(getCenter != null) {
                Box(
                    modifier = Modifier
                        .background(Color.Magenta)
                        .align(Alignment.Center)
                        .fillMaxSize()  // Make the center component fill the empty space
                ) {
                    getCenter.nativeComponent()
                }
            }
            Box(
                modifier = Modifier
                    .background(Color.Cyan)
                    .align(Alignment.CenterEnd)
                    .size(50.dp, 50.dp)
            ) {
                eastDockingBar.nativeComponent.nativeComponent()
            }
            Box(
                modifier = Modifier
                    .background(Color.Black)
                    .align(Alignment.BottomStart)
                    .size(50.dp, 50.dp)
            ) {
                ComposeDockingCorner().nativeComponent()
            }
            Box(
                modifier = Modifier
                    .background(Color.White)
                    .align(Alignment.BottomCenter)
                    .size(50.dp, 50.dp)
            ) {
                southDockingBar.nativeComponent.nativeComponent()
            }
            Box(
                modifier = Modifier
                    .background(Color.LightGray)
                    .align(Alignment.BottomEnd)
                    .size(50.dp, 50.dp)
            ) {
                ComposeDockingCorner().nativeComponent()
            }
        }
    })

    private var primarySplitter: CPThreeComponentsSplitter = CPThreeComponentsSplitter(vertical)
    private var secondarySplitter: CPThreeComponentsSplitter = CPThreeComponentsSplitter(!vertical)
    override val westDockingBar: DockingBar<CPComponent> = ComposeDockingBar(westContainerPanel, DockingAnchor.LEFT)
    override val eastDockingBar: DockingBar<CPComponent> = ComposeDockingBar(eastContainerPanel, DockingAnchor.RIGHT)
    override val southDockingBar: DockingBar<CPComponent> = ComposeDockingBar(southContainerPanel, DockingAnchor.BOTTOM)
    override val northDockingBar: DockingBar<CPComponent> = ComposeDockingBar(northContainerPanel, DockingAnchor.TOP)

    override var innerComponent: CPComponent? = null
        get() { return field }
        set(value) {
            field = value

            updateDockingContainers()
        }
    init {
        updateDockingContainers()
        updateDockingBars()
//            secondarySplitter.setShowDividerControls(true);
//            primarySplitter.setShowDividerControls(true);
        center.value = primarySplitter
    }

    override fun setOrientation(vertical: Boolean) {
        if (this.vertical != vertical) {
            this.vertical = vertical
            var innerComponent: CPComponent? = null
            var secondaryFirstSize: Double = secondarySplitter.firstSize
            var secondaryLastSize: Double = secondarySplitter.lastSize
            var primaryFirstSize: Double = primarySplitter.firstSize
            var primaryLastSize: Double = primarySplitter.lastSize

            secondaryFirstSize = secondarySplitter.firstSizeIfVisible
            secondaryLastSize = secondarySplitter.lastSizeIfVisible
            innerComponent = secondarySplitter.innerComponent
            secondarySplitter.setComponents(null, null, null)

            primaryFirstSize = primarySplitter.firstSizeIfVisible
            primaryLastSize = primarySplitter.lastSizeIfVisible
            primarySplitter.setComponents(null, null, null)

            primarySplitter.vertical = vertical
            secondarySplitter.vertical = !vertical

            secondarySplitter.firstSize = primaryFirstSize
            secondarySplitter.lastSize = primaryLastSize

            primarySplitter.firstSize = secondaryFirstSize
            primarySplitter.lastSize = secondaryLastSize

            updateDockingContainers()
        }
    }

    private val horizontalSplitter: ThreeComponentsSplitter<CPComponent?>
        get() = if (!vertical) {
            primarySplitter
        } else {
            secondarySplitter
        }
    private val verticalSplitter: ThreeComponentsSplitter<CPComponent?>
        get() = if (vertical) {
            primarySplitter
        } else {
            secondarySplitter
        }

    override var horizontalFirstDividerSize: Double
        get() = horizontalSplitter.firstSizeIfVisible
        set(size) {
            horizontalSplitter.firstSize = size
        }

    override var horizontalLastDividerSize: Double
        get() = secondarySplitter.lastSizeIfVisible
        set(size) {
            secondarySplitter.lastSize = size
        }

    override var verticalFirstDividerSize: Double
        get() = verticalSplitter.firstSizeIfVisible
        set(size) {
            verticalSplitter.firstSize = size
        }

    override var verticalLastDividerSize: Double
        get() = verticalSplitter.lastSizeIfVisible
        set(size) {
            verticalSplitter.lastSize = size
        }

    override fun setHorizontalRelativeSize(relativeResize: Boolean) {
        horizontalSplitter.isRelativeResize = relativeResize
    }

    override fun setVerticalRelativeResize(relativeResize: Boolean) {
        verticalSplitter.isRelativeResize = relativeResize
    }

    override fun dispose() {
    }

    override fun attach(dockable: Dockable<CPComponent>?, anchor: AttachAnchor?) {
        when (anchor) {
            AttachAnchor.TOP -> northDockingBar.attach(dockable!!)
            AttachAnchor.BOTTOM -> southDockingBar.attach(dockable!!)
            AttachAnchor.LEFT -> westDockingBar.attach(dockable!!)
            AttachAnchor.RIGHT -> eastDockingBar.attach(dockable!!)
            AttachAnchor.CENTER -> innerComponent = dockable!!.component
            null -> TODO()
        }
        updateDockingBars()
    }

    private fun updateDockingBars() {
//        nativeComponent.setWidgetHidden(getNorthDockingBar().getNativeComponent(), getNorthDockingBar().getDockables().size() == 0);
//        nativeComponent.setWidgetHidden(getSouthDockingBar().getNativeComponent(), getSouthDockingBar().getDockables().size() == 0);
//        nativeComponent.setWidgetHidden(getWestDockingBar().getNativeComponent(), getWestDockingBar().getDockables().size() == 0);
//        nativeComponent.setWidgetHidden(getEastDockingBar().getNativeComponent(), getEastDockingBar().getDockables().size() == 0);

        updateDockingContainers()
    }

    fun updateDockingContainers() {
        if (vertical) {
            secondarySplitter.setComponents(westContainerPanel, innerComponent, eastContainerPanel)
            primarySplitter.setComponents(northContainerPanel, secondarySplitter, southContainerPanel)
        } else {
            secondarySplitter.setComponents(northContainerPanel, innerComponent, southContainerPanel)
            primarySplitter.setComponents(westContainerPanel, secondarySplitter, eastContainerPanel)
        }
    }

    override fun createNakedDockable(component: CPComponent, title: String?): Dockable<CPComponent>? {
        return createNakedDockable(component, title)
    }

    override fun createNakedDockable(component: CPComponent, title: String?, icon: String?): Dockable<CPComponent>? {
        return CPNakedDockable(component, title, iconURL =  icon)
    }

    override fun createDecoratedDockable(component: CPComponent, title: String?): Dockable<CPComponent>? {
        return createDecoratedDockable(component, title)
    }

    override fun createDecoratedDockable(component: CPComponent, shortTitle: String?, title: String?, description: String?): Dockable<CPComponent>? {
        return createDecoratedDockable(component, title, shortTitle, description = description)
    }

//    fun createNakedDockable(component: JComponent, title: String?, icon: ImageIcon?): Dockable<JComponent> {
//        return NakedDockable(component, title!!, null)
//    }

    fun createDecoratedDockable(component: CPComponent, title: String?, iconUrl: String?): Dockable<CPComponent> {
        return CPNakedDockable(component, title, iconUrl = iconUrl)
    }

    fun createDecoratedDockable(component: CPComponent, shortTitle: String?, title: String?, description: String?, iconUrl: String?): Dockable<CPComponent> {
        return CPNakedDockable(component, title, shortTitle, iconUrl, description, iconUrl)
    }
}