/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.js.splitter

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.SimpleProperty
import com.macrofocus.docking.splitter.AbstractThreeComponentsSplitter
import org.mkui.component.CPComponent
import org.mkui.compose.toState

class CPThreeComponentsSplitter constructor(vertical: Boolean = false) :
    AbstractThreeComponentsSplitter<CPComponent?>(), CPComponent {
    private val firstComponentProperty: MutableProperty<CPComponent?> = SimpleProperty(null)
    private val innerComponentProperty: MutableProperty<CPComponent?> = SimpleProperty(null)
    private val lastComponentProperty: MutableProperty<CPComponent?> = SimpleProperty(null)

    private val firstSizeProperty: MutableProperty<Double> = SimpleProperty(0.0)
    private val lastSizeProperty: MutableProperty<Double> = SimpleProperty(0.0)

    private val verticalProperty: MutableProperty<Boolean> = SimpleProperty(vertical)
    private val isRelativeResizeProperty: MutableProperty<Boolean> = SimpleProperty(false)
    private val showDividerControls: MutableProperty<Boolean> = SimpleProperty(true)

    val nc: @Composable () -> Unit = {
        val (vertical, _) = verticalProperty.toState()
        val (isRelativeResize, _) = isRelativeResizeProperty.toState()

        val (myFirstComponent, _) = firstComponentProperty.toState()
        val (myInnerComponent, _) = innerComponentProperty.toState()
        val (myLastComponent, _) = lastComponentProperty.toState()

        val (firstDividerPosition, _) = firstSizeProperty.toState()
        val (lastDividerPosition, _) = lastSizeProperty.toState()

        if (vertical) {
            Column(
                modifier = Modifier
                    .fillMaxSize()
                    .background(if(vertical) Color.DarkGray else Color.LightGray)
            ) {
                if (myFirstComponent != null) {
                    Box(
                        modifier = if (isRelativeResize) {
                            Modifier
                                .background(Color.Yellow)
                                .fillMaxWidth()
                                .weight(firstDividerPosition.toFloat())
                        } else {
                            Modifier
                                .background(Color.Green)
                                .fillMaxWidth()
                                .height(firstDividerPosition.dp)
                        }
                    ) {
                        myFirstComponent.nativeComponent.invoke()
                    }
                }
                if (myInnerComponent != null) {
                    Box(
                        modifier = if (isRelativeResize) {
                            Modifier
                                .background(Color.Yellow)
                                .fillMaxWidth()
                                .weight(1f)
                        } else {
                            Modifier
                                .background(Color.Yellow)
                                .fillMaxWidth()
                                .weight(1f)
                        }
                    ) {
                        myInnerComponent.nativeComponent.invoke()
                    }
                }
                if (myLastComponent != null) {
                    Box(
                        modifier = if (isRelativeResize) {
                            Modifier
                                .background(Color.Blue)
                                .fillMaxWidth()
                                .weight(lastDividerPosition.toFloat())
                        } else {
                            Modifier
                                .background(Color.Blue)
                                .fillMaxWidth()
                                .height(lastDividerPosition.dp)
                        }
                    ) {
                        myLastComponent.nativeComponent.invoke()
                    }
                }
            }
        } else {
            Row(
                modifier = Modifier
                    .fillMaxSize()
                    .background(Color.Gray)
            ) {
                if (myFirstComponent != null) {
                    Box(
                        modifier = if (isRelativeResize) {
                            Modifier
                                .background(Color.Green)
                                .fillMaxHeight()
                                .weight(firstDividerPosition.toFloat())
                        } else {
                            Modifier
                                .background(Color.Green)
                                .fillMaxHeight()
                                .width(firstDividerPosition.dp)
                        }
                    ) {
                        myFirstComponent.nativeComponent.invoke()
                    }
                }
                if (myInnerComponent != null) {
                    Box(
                        modifier = Modifier
                            .background(Color.Red)
                            .fillMaxHeight()
                            .weight(1f)
                    ) {
                        myInnerComponent.nativeComponent.invoke()
                    }
                }
                if (myLastComponent != null) {
                    Box(
                        modifier = if (isRelativeResize) {
                            Modifier
                                .background(Color.Blue)
                                .fillMaxHeight()
                                .weight(lastDividerPosition.toFloat())
                        } else {
                            Modifier
                                .background(Color.Blue)
                                .fillMaxHeight()
                                .width(lastDividerPosition.dp)
                        }
                    ) {
                        myLastComponent.nativeComponent.invoke()
                    }
                }
            }
        }
    }
    override val nativeComponent: @Composable () -> Unit = nc

    override var vertical by verticalProperty
    override var isRelativeResize: Boolean by isRelativeResizeProperty
    override var firstComponent: CPComponent? by firstComponentProperty
    override var innerComponent: CPComponent? by innerComponentProperty
    override var lastComponent: CPComponent? by lastComponentProperty

    override fun setComponents(first: CPComponent?, inner: CPComponent?, last: CPComponent?) {
//        saveDividerPositions();

        firstComponent = first
        innerComponent = inner
        lastComponent = last

        //        restoreDividerPositions();
    }

    private fun restoreDividerPositions() {
        println("Restoring $firstSizeProperty, $lastSizeProperty")
    }

    private fun saveDividerPositions() {
        println("Saving $firstSizeProperty, $lastSizeProperty")
    }

    override var firstSize: Double by firstSizeProperty

    override var lastSize: Double by lastSizeProperty

    override val firstSizeIfVisible: Double
        get() = if (firstVisible()) firstSize else 0.0

    override val lastSizeIfVisible: Double
        get() = if (lastVisible()) lastSize else 0.0

    override fun setWidgetHidden(widget: CPComponent?, hidden: Boolean) {
    }

    override fun setShowDividerControls(show: Boolean) {
        showDividerControls.value = show
    }

    private fun firstVisible(): Boolean {
        return firstComponent != null
    }

    private fun lastVisible(): Boolean {
        return lastComponent != null
    }

    private fun innerVisible(): Boolean {
        return innerComponent != null
    }

    private fun visibleDividersCount(): Int {
        var count = 0
        if (firstDividerVisible()) count++
        if (lastDividerVisible()) count++
        return count
    }

    private fun firstDividerVisible(): Boolean {
        return (firstVisible() && innerVisible()) || (firstVisible() && lastVisible() && !innerVisible())
    }

    private fun lastDividerVisible(): Boolean {
        return innerVisible() && lastVisible()
    }
}
