/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.compose

import com.macrofocus.docking.Dockable
import com.macrofocus.docking.DockingBar
import org.mkui.component.CPComponent

class ComposeDockable(
    override val container: CPComponent?,
    override val shortTitle: String?,
    override val title: String?,
    override val description: String?,
    override val iconURL: String?
) : Dockable<CPComponent> {
    override var dockingBar: DockingBar<CPComponent>? = null
    override val component: CPComponent?
        get() = container

    constructor(component: CPComponent?, title: String?, iconUrl: String?) : this(component, title, title, null, iconUrl)

    override fun detachContainer(): CPComponent? {
        return null
    }

    override fun attachContainer() {
    }

    override fun dispose() {
    }
}
