/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.compose

import androidx.compose.runtime.Composable
import com.macrofocus.common.properties.SimpleProperty
import org.mkui.component.CPComponent
import org.mkui.compose.toState

class ComposeDockingCorner constructor() : CPComponent {
    private val component = SimpleProperty.newInstance<CPComponent?>(null)

    override val nativeComponent: @Composable () -> Unit = {
        var component by component.toState()

        if(component != null) {
            component!!.nativeComponent()
        }
    }
}