/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.compose

import androidx.compose.runtime.Composable
import com.macrofocus.common.properties.SimpleProperty
import org.mkui.component.CPComponent
import org.mkui.compose.toState

class DockingContainer constructor() : CPComponent {
    private val component = SimpleProperty.newInstance<CPComponent?>(null)
    private val visibleProperty = SimpleProperty.newInstance<Boolean>(true)

    var center by component
    var visible by visibleProperty

    override val nativeComponent: @Composable () -> Unit = {
        val component by component.toState()
        val visible by visibleProperty.toState()

        if(component != null && visible) {
            component!!.nativeComponent()
        }
    }

    fun remove(c: CPComponent?) {
        if(component.value == c) {
            component.value = null
        } else {
            println("DockingContainer: could not find component $c")
        }
    }
}