/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.javafx

import com.macrofocus.docking.DockingAnchor
import javafx.scene.control.ToggleButton

class DockingButton(orientation: DockingAnchor) : ToggleButton() {
    init {
        styleClass.add("toggleButton")

        if (orientation == DockingAnchor.LEFT) {
            rotate = 270.0
        } else if (orientation == DockingAnchor.RIGHT) {
            rotate = 90.0
        }
    }
}
