/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.javafx

import com.macrofocus.docking.Dockable
import com.macrofocus.docking.DockingBar
import javafx.scene.Node

class JavaFXDockable(
    override val container: Node?,
    override val shortTitle: String?,
    override val title: String?,
    override val description: String?,
    override val iconURL: String?
) : Dockable<Node> {
    override var dockingBar: DockingBar<Node>? = null
    override val component: Node?
        get() = container

    constructor(component: Node?, title: String?, iconUrl: String?) : this(component, title, title, null, iconUrl)

    override fun detachContainer(): Node? {
        return null
    }

    override fun attachContainer() {
    }

    override fun dispose() {
    }
}
