/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.javafx

import javafx.application.Application
import javafx.event.ActionEvent
import javafx.event.EventHandler
import javafx.scene.Node
import javafx.scene.Scene
import javafx.scene.control.CheckMenuItem
import javafx.scene.control.Label
import javafx.scene.control.Menu
import javafx.scene.control.MenuBar
import javafx.scene.layout.Background
import javafx.scene.layout.BackgroundFill
import javafx.scene.layout.BorderPane
import javafx.scene.paint.Color
import javafx.stage.Stage

class JavaFXDockingDemo : Application() {
    @Throws(Exception::class)
    override fun start(frame: Stage) {
        frame.title = "Docking Demo"
        frame.width = 1000.0
        frame.height = 700.0
        frame.show()

        val docking = JavaFXDockingPanel()

        val comp0 = createContent(Color.WHITE)
        val comp1 = createContent(Color.RED)
        val comp2 = createContent(Color.GREEN)
        val comp3 = createContent(Color.BLUE)
        val comp4 = createContent(Color.PINK)
        val comp5 = createContent(Color.CYAN)
        val comp6 = createContent(Color.MAGENTA)
        val comp7 = createContent(Color.YELLOW)
        val comp8 = createContent(Color.ORANGE)
        val comp9 = createContent(Color.BEIGE)
        val comp10 = createContent(Color.DARKVIOLET)
        //        ImageIcon icon = new ImageIcon(getClass().getResource("macrofocus.png"));
        val icon: String? = null
        docking.innerComponent = docking.createDecoratedDockable(comp0, "Zero", icon).component
        docking.westDockingBar!!.attach(docking.createDecoratedDockable(comp1, "One", icon))
        docking.westDockingBar!!.attach(docking.createDecoratedDockable(comp2, "Two", icon))
        docking.westDockingBar!!.attach(docking.createDecoratedDockable(comp3, "Three", icon))
        docking.westDockingBar!!.attach(docking.createDecoratedDockable(comp4, "Four", icon))
        docking.eastDockingBar!!.attach(docking.createDecoratedDockable(comp5, "Five", icon))
        docking.eastDockingBar!!.attach(docking.createDecoratedDockable(comp6, "Six", icon))
        docking.southDockingBar!!.attach(docking.createDecoratedDockable(comp7, "Seven", icon))
        docking.southDockingBar!!.attach(docking.createDecoratedDockable(comp8, "Eight", icon))
        docking.northDockingBar!!.attach(docking.createDecoratedDockable(comp9, "Nine", icon))
        docking.northDockingBar!!.attach(docking.createDecoratedDockable(comp10, "Ten", icon))

        val menuBar = MenuBar()
        menuBar.isUseSystemMenuBar = true
        val fileMenu = Menu("File")
        //        PrintJComponentAction printAction = new PrintJComponentAction(frame);
//        fileMenu.add(printAction);
        menuBar.menus.add(fileMenu)
        //
        val optionsMenu = Menu("Options")
        val verticalOrientation = CheckMenuItem("Vertical")
        verticalOrientation.isSelected = true
        optionsMenu.items.add(verticalOrientation)
        verticalOrientation.onAction =
            EventHandler { event: ActionEvent? -> docking.setOrientation(verticalOrientation.isSelected) }
        menuBar.menus.add(optionsMenu)

        val root = BorderPane()
        val scene = Scene(root)
        frame.scene = scene
        root.top = menuBar
        root.center = docking.nativeComponent

        //        docking.setHorizontalFirstDividerSize(250);
//        docking.setHorizontalLastDividerSize(300);
//        docking.setVerticalFirstDividerSize(100);
//        docking.setVerticalLastDividerSize(300);
    }

    fun createContent(color: Color): Node {
        val comp = Label()
        comp.text = color.toString()
        comp.setPrefSize(Double.MAX_VALUE, Double.MAX_VALUE)
        comp.setMaxSize(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY)
        comp.background = Background(BackgroundFill(color, null, null))

        return comp
    }

    companion object {
        @JvmStatic
        fun main(args: Array<String>) {
            launch(JavaFXDockingDemo::class.java, *args)
        }
    }
}
