/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking

interface DockingBar<C> {
    fun attach(dockable: com.macrofocus.docking.Dockable<C>?)
    fun detach(dockable: com.macrofocus.docking.Dockable<C>?)
    fun removeAll()
    fun isActive(dockable: com.macrofocus.docking.Dockable<C>?): Boolean
    fun setActive(dockable: com.macrofocus.docking.Dockable<C>?, active: Boolean)
    fun setFloating(dockable: com.macrofocus.docking.Dockable<C>?, floating: Boolean)
    fun setSliding(dockable: com.macrofocus.docking.Dockable<C>?, sliding: Boolean)
    val dockables: List<com.macrofocus.docking.Dockable<C>?>?
    fun dispose()
    val nativeComponent: C
}