/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking

/**
 * User: luc
 * Date: Jun 1, 2006
 * Time: 2:12:18 PM
 */
class DockingState {
    var isActive = false
    var anchor: com.macrofocus.docking.DockingAnchor? = null
        set(toolwindowanchor) {
            requireNotNull(toolwindowanchor) { "anchor cannot be null" }
            field = toolwindowanchor
            return
        }
    var isAutoHide = false

    //    Rectangle getFloatingBounds() {
    //        return floatingBounds;
    //    }
    //    private Rectangle floatingBounds;
    val id: String? = null
    private var internalType: com.macrofocus.docking.DockingType? = null
    private var type: com.macrofocus.docking.DockingType? = null
    var isVisible = false
    var weight = 0f
        set(f1) {
            var f1 = f1
            if (f1 < 0.0f) f1 = 0.0f else if (f1 > 1.0f) f1 = 1.0f
            field = f1
        }
    var order = 0
    fun getInternalType(): com.macrofocus.docking.DockingType? {
        return internalType
    }

    fun getType(): com.macrofocus.docking.DockingType? {
        return type
    }

    val isDocked: Boolean
        get() = com.macrofocus.docking.DockingType.Companion.DOCKED == type
    val isFloating: Boolean
        get() = com.macrofocus.docking.DockingType.Companion.FLOATING == type
    val isSliding: Boolean
        get() = com.macrofocus.docking.DockingType.Companion.SLIDING == type

    //    void setFloatingBounds(Rectangle rectangle) {
    //        floatingBounds = rectangle;
    //    }
    fun setType(toolwindowtype: com.macrofocus.docking.DockingType?) {
        requireNotNull(toolwindowtype) { "type cannot be null" }
        if (com.macrofocus.docking.DockingType.Companion.DOCKED == toolwindowtype || com.macrofocus.docking.DockingType.Companion.SLIDING == toolwindowtype) internalType =
            toolwindowtype
        type = toolwindowtype
    }

    companion object {
        const val DEFAULT_WEIGHT = 0.33f
    }
}