/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking

interface DockingPanel<C> {
    fun setOrientation(vertical: Boolean)
    var horizontalFirstDividerSize: Double
    var horizontalLastDividerSize: Double
    var verticalFirstDividerSize: Double
    var verticalLastDividerSize: Double
    fun setHorizontalRelativeSize(relativeResize: Boolean)
    fun setVerticalRelativeResize(relativeResize: Boolean)
    val westDockingBar: DockingBar<C>?
    val northDockingBar: DockingBar<C>?
    val southDockingBar: DockingBar<C>?
    val eastDockingBar: DockingBar<C>?
    var innerComponent: C?
    fun dispose()
    fun attach(dockable: Dockable<C>?, anchor: AttachAnchor?)
    fun createNakedDockable(component: C, title: String?): com.macrofocus.docking.Dockable<C>?
    fun createNakedDockable(component: C, title: String?, icon: String?): com.macrofocus.docking.Dockable<C>?
    fun createDecoratedDockable(component: C, title: String?): com.macrofocus.docking.Dockable<C>?
    fun createDecoratedDockable(
        component: C,
        shortTitle: String?,
        title: String?,
        description: String?
    ): com.macrofocus.docking.Dockable<C>?

    val nativeComponent: C
}