/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.js

import com.macrofocus.common.properties.SimpleProperty
import js.objects.jso
import org.mkui.component.CPComponent
import org.mkui.component.Empty
import org.mkui.react.toState
import react.FC
import react.Props
import react.dom.html.ReactHTML
import web.cssom.*

class DockingContainer constructor() : CPComponent {
    private val component = SimpleProperty.newInstance<CPComponent?>(null)
    private val visibleProperty = SimpleProperty.newInstance<Boolean>(true)

    var center by component
    var visible by visibleProperty

    override val nativeComponent = FC<Props> { props ->
        val (component, _) = component.toState()
        val (visible, _) = visibleProperty.toState()

        ReactHTML.div {
            className = ClassName("DockingContainer")

            style = jso {
                overflow = Overflow.hidden
                display = Display.block

                if(component != null && visible) {
                    width = 100.pct
                    height = 100.pct
                } else {
                    width = 0.px
                    height = 0.px
                }
            }

            if(component != null && visible) {
                component.nativeComponent()
            } else {
                Empty {}
            }
        }
    }

    fun remove(c: CPComponent?) {
        if(component.value == c) {
            component.value = null
        } else {
            println("DockingContainer: could not find component $c")
        }
    }
}