/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.js

import com.macrofocus.common.properties.SimpleProperty
import org.mkui.component.CPComponent
import org.mkui.react.toState
import react.FC
import react.Props
import react.dom.html.ReactHTML

class JsDockingCorner constructor() : CPComponent {
    private val component = SimpleProperty.newInstance<CPComponent?>(null)

    override val nativeComponent = FC<Props> { props ->
        val (component, _) = component.toState()

        if(component != null) {
            component.nativeComponent()
        } else {
            ReactHTML.div {}
        }
    }
}