/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking

/**
 * User: luc
 * Date: Jun 1, 2006
 * Time: 2:12:18 PM
 */
class DockingState {
    var isActive = false
    var anchor: DockingAnchor? = null
        set(toolwindowanchor) {
            requireNotNull(toolwindowanchor) { "anchor cannot be null" }
            field = toolwindowanchor
            return
        }
    var isAutoHide = false

    //    Rectangle getFloatingBounds() {
    //        return floatingBounds;
    //    }
    //    private Rectangle floatingBounds;
    val id: String? = null
    private var internalType: DockingType? = null
    private var type: DockingType? = null
    var isVisible = false
    var weight = 0f
        set(f1) {
            var f1 = f1
            if (f1 < 0.0f) f1 = 0.0f else if (f1 > 1.0f) f1 = 1.0f
            field = f1
        }
    var order = 0
    fun getInternalType(): DockingType? {
        return internalType
    }

    fun getType(): DockingType? {
        return type
    }

    val isDocked: Boolean
        get() = DockingType.DOCKED == type
    val isFloating: Boolean
        get() = DockingType.FLOATING == type
    val isSliding: Boolean
        get() = DockingType.SLIDING == type

    //    void setFloatingBounds(Rectangle rectangle) {
    //        floatingBounds = rectangle;
    //    }
    fun setType(toolwindowtype: com.macrofocus.docking.DockingType?) {
        requireNotNull(toolwindowtype) { "type cannot be null" }
        if (DockingType.DOCKED == toolwindowtype || DockingType.SLIDING == toolwindowtype) internalType =
            toolwindowtype
        type = toolwindowtype
    }

    companion object {
        const val DEFAULT_WEIGHT = 0.33f
    }
}