package com.macrofocus.docking.js

import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.SimpleProperty
import com.macrofocus.docking.*
import com.macrofocus.docking.js.splitter.CPThreeComponentsSplitter
import com.macrofocus.docking.splitter.ThreeComponentsSplitter
import js.objects.unsafeJso
import org.mkui.component.CPComponent
import org.mkui.component.ReactComponent
import org.mkui.react.toState
import react.FC
import react.Props
import react.dom.html.ReactHTML
import react.dom.html.ReactHTML.div
import web.cssom.*

class JsDockingPanel(private var vertical: Boolean = true) : DockingPanel<CPComponent> {
    val center : MutableProperty<CPComponent?> = SimpleProperty<CPComponent?>(null)

    val westContainerPanel: DockingContainer = DockingContainer()
    val eastContainerPanel: DockingContainer = DockingContainer()
    val southContainerPanel: DockingContainer = DockingContainer()
    val northContainerPanel: DockingContainer = DockingContainer()

    override val nativeComponent: CPComponent = ReactComponent(FC<Props> {
        val (getCenter, _) = center.toState()

        div {
            style = unsafeJso {
                display = Display.grid
                gridTemplateColumns = array(Length.minContent, 1.fr, Length.minContent)
                gridTemplateRows = array(Length.minContent, 1.fr, Length.minContent)
                height = 100.pct
                top = 0.px
                bottom = 0.px
                left = 0.px
                right = 0.px
                position = Position.relative
                pointerEvents = None.none
            }

            JsDockingCorner().nativeComponent()
            northDockingBar.nativeComponent.nativeComponent()
            JsDockingCorner().nativeComponent()

            westDockingBar.nativeComponent.nativeComponent()
            if(getCenter != null) {
                getCenter.nativeComponent()
            } else {
                div {}
            }
            eastDockingBar.nativeComponent.nativeComponent()

            JsDockingCorner().nativeComponent()
            southDockingBar.nativeComponent.nativeComponent()
            JsDockingCorner().nativeComponent()
        }
    })

    private var primarySplitter: CPThreeComponentsSplitter = CPThreeComponentsSplitter(vertical)
    private var secondarySplitter: CPThreeComponentsSplitter = CPThreeComponentsSplitter(!vertical)
    override val westDockingBar: DockingBar<CPComponent> = JsDockingBar(westContainerPanel, DockingAnchor.LEFT)
    override val eastDockingBar: DockingBar<CPComponent> = JsDockingBar(eastContainerPanel, DockingAnchor.RIGHT)
    override val southDockingBar: DockingBar<CPComponent> = JsDockingBar(southContainerPanel, DockingAnchor.BOTTOM)
    override val northDockingBar: DockingBar<CPComponent> = JsDockingBar(northContainerPanel, DockingAnchor.TOP)

    override var innerComponent: CPComponent? = null
        get() { return field }
        set(value) {
            field = value

            updateDockingContainers()
        }
    init {
        updateDockingContainers()
        updateDockingBars()
//            secondarySplitter.setShowDividerControls(true);
//            primarySplitter.setShowDividerControls(true);
        center.value = primarySplitter
    }

    override fun setOrientation(vertical: Boolean) {
        if (this.vertical != vertical) {
            this.vertical = vertical
            var innerComponent: CPComponent? = null
            var secondaryFirstSize: Double = secondarySplitter.firstSize
            var secondaryLastSize: Double = secondarySplitter.lastSize
            var primaryFirstSize: Double = primarySplitter.firstSize
            var primaryLastSize: Double = primarySplitter.lastSize

            secondaryFirstSize = secondarySplitter.firstSizeIfVisible
            secondaryLastSize = secondarySplitter.lastSizeIfVisible
            innerComponent = secondarySplitter.innerComponent
            secondarySplitter.setComponents(null, null, null)

            primaryFirstSize = primarySplitter.firstSizeIfVisible
            primaryLastSize = primarySplitter.lastSizeIfVisible
            primarySplitter.setComponents(null, null, null)

            primarySplitter.vertical = vertical
            secondarySplitter.vertical = !vertical

            secondarySplitter.firstSize = primaryFirstSize
            secondarySplitter.lastSize = primaryLastSize

            primarySplitter.firstSize = secondaryFirstSize
            primarySplitter.lastSize = secondaryLastSize

            updateDockingContainers()
        }
    }

    private val horizontalSplitter: ThreeComponentsSplitter<CPComponent?>
        get() = if (!vertical) {
            primarySplitter
        } else {
            secondarySplitter
        }
    private val verticalSplitter: ThreeComponentsSplitter<CPComponent?>
        get() = if (vertical) {
            primarySplitter
        } else {
            secondarySplitter
        }

    override var horizontalFirstDividerSize: Double
        get() = horizontalSplitter.firstSizeIfVisible
        set(size) {
            horizontalSplitter.firstSize = size
        }

    override var horizontalLastDividerSize: Double
        get() = secondarySplitter.lastSizeIfVisible
        set(size) {
            secondarySplitter.lastSize = size
        }

    override var verticalFirstDividerSize: Double
        get() = verticalSplitter.firstSizeIfVisible
        set(size) {
            verticalSplitter.firstSize = size
        }

    override var verticalLastDividerSize: Double
        get() = verticalSplitter.lastSizeIfVisible
        set(size) {
            verticalSplitter.lastSize = size
        }

    override fun setHorizontalRelativeSize(relativeResize: Boolean) {
        horizontalSplitter.isRelativeResize = relativeResize
    }

    override fun setVerticalRelativeResize(relativeResize: Boolean) {
        verticalSplitter.isRelativeResize = relativeResize
    }

    override fun dispose() {
    }

    override fun attach(dockable: Dockable<CPComponent>?, anchor: AttachAnchor?) {
        when (anchor) {
            AttachAnchor.TOP -> northDockingBar.attach(dockable!!)
            AttachAnchor.BOTTOM -> southDockingBar.attach(dockable!!)
            AttachAnchor.LEFT -> westDockingBar.attach(dockable!!)
            AttachAnchor.RIGHT -> eastDockingBar.attach(dockable!!)
            AttachAnchor.CENTER -> innerComponent = dockable!!.component
            null -> TODO()
        }
        updateDockingBars()
    }

    private fun updateDockingBars() {
//        nativeComponent.setWidgetHidden(getNorthDockingBar().getNativeComponent(), getNorthDockingBar().getDockables().size() == 0);
//        nativeComponent.setWidgetHidden(getSouthDockingBar().getNativeComponent(), getSouthDockingBar().getDockables().size() == 0);
//        nativeComponent.setWidgetHidden(getWestDockingBar().getNativeComponent(), getWestDockingBar().getDockables().size() == 0);
//        nativeComponent.setWidgetHidden(getEastDockingBar().getNativeComponent(), getEastDockingBar().getDockables().size() == 0);

        updateDockingContainers()
    }

    fun updateDockingContainers() {
        if (vertical) {
            secondarySplitter.setComponents(westContainerPanel, innerComponent, eastContainerPanel)
            primarySplitter.setComponents(northContainerPanel, secondarySplitter, southContainerPanel)
        } else {
            secondarySplitter.setComponents(northContainerPanel, innerComponent, southContainerPanel)
            primarySplitter.setComponents(westContainerPanel, secondarySplitter, eastContainerPanel)
        }
    }

    override fun createNakedDockable(component: CPComponent, title: String?): Dockable<CPComponent>? {
        return createNakedDockable(component, title)
    }

    override fun createNakedDockable(component: CPComponent, title: String?, icon: String?): Dockable<CPComponent>? {
        return CPNakedDockable(component, title, iconURL =  icon)
    }

    override fun createDecoratedDockable(component: CPComponent, title: String?): Dockable<CPComponent>? {
        return createDecoratedDockable(component, title)
    }

    override fun createDecoratedDockable(component: CPComponent, shortTitle: String?, title: String?, description: String?): Dockable<CPComponent>? {
        return createDecoratedDockable(component, title, shortTitle, description = description)
    }

//    fun createNakedDockable(component: JComponent, title: String?, icon: ImageIcon?): Dockable<JComponent> {
//        return NakedDockable(component, title!!, null)
//    }

    fun createDecoratedDockable(component: CPComponent, title: String?, iconUrl: String?): Dockable<CPComponent> {
        return CPNakedDockable(component, title, iconUrl = iconUrl)
    }

    fun createDecoratedDockable(component: CPComponent, shortTitle: String?, title: String?, description: String?, iconUrl: String?): Dockable<CPComponent> {
        return CPNakedDockable(component, title, shortTitle, iconUrl, description, iconUrl)
    }
}