/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.js.splitter

import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.SimpleProperty
import com.macrofocus.docking.splitter.AbstractThreeComponentsSplitter
import js.objects.unsafeJso
import org.mkui.component.CPComponent
import org.mkui.component.Empty
import org.mkui.react.toState
import react.FC
import react.Props
import react.dom.html.ReactHTML
import web.cssom.*

class CPThreeComponentsSplitter constructor(vertical: Boolean = false) : AbstractThreeComponentsSplitter<CPComponent?>(), CPComponent {
    private val firstComponentProperty: MutableProperty<CPComponent?> = SimpleProperty(null)
    private val innerComponentProperty: MutableProperty<CPComponent?> = SimpleProperty(null)
    private val lastComponentProperty: MutableProperty<CPComponent?> = SimpleProperty(null)

    private val firstSizeProperty: MutableProperty<Double> = SimpleProperty(0.0)
    private val lastSizeProperty: MutableProperty<Double> = SimpleProperty(0.0)

    private val verticalProperty: MutableProperty<Boolean> = SimpleProperty(vertical)
    private val isRelativeResizeProperty: MutableProperty<Boolean> = SimpleProperty(false)
    private val showDividerControls: MutableProperty<Boolean> = SimpleProperty(true)

    val nc:  FC<*> = FC<Props> {
        val (vertical, _) = verticalProperty.toState()
        val (isRelativeResize, _) = isRelativeResizeProperty.toState()

        val (myFirstComponent, _) = firstComponentProperty.toState()
        val (myInnerComponent, _) = innerComponentProperty.toState()
        val (myLastComponent, _) = lastComponentProperty.toState()

        val (firstDividerPosition, _) = firstSizeProperty.toState()
        val (lastDividerPosition, _) = lastSizeProperty.toState()

        ReactHTML.div {
            style = unsafeJso {
                width = 100.pct
                height = 100.pct
            }

            style = unsafeJso {
                display = Display.grid
                val full: GridTemplateTracks = array(100.pct)
                val breaks: GridTemplateTracks
                val first = if(myFirstComponent != null) if(isRelativeResize) firstDividerPosition.pct else firstDividerPosition.px else 0.px
                val last = if(myLastComponent != null) if(isRelativeResize) lastDividerPosition.pct else lastDividerPosition.px else 0.px
                breaks = array(first, Auto.auto, last)
                if(vertical) {
                    gridTemplateColumns = full
                    gridTemplateRows = breaks
                } else {
                    gridTemplateColumns = breaks
                    gridTemplateRows = full
                }
                height = 100.pct
                minHeight = 0.px
            }

            if(myFirstComponent != null) {
                myFirstComponent.nativeComponent.invoke()
            } else {
                Empty {}
            }
            if(myInnerComponent != null) {
                myInnerComponent?.nativeComponent?.invoke()
            } else {
                Empty {}
            }
            if(myLastComponent != null) {
                myLastComponent.nativeComponent.invoke()
            } else {
                Empty {}
            }
        }
    }
    override val nativeComponent: FC<*> = nc

    override var vertical by verticalProperty
    override var isRelativeResize: Boolean by isRelativeResizeProperty
    override var firstComponent: CPComponent? by firstComponentProperty
    override var innerComponent: CPComponent? by innerComponentProperty
    override var lastComponent: CPComponent? by lastComponentProperty

    override fun setComponents(first: CPComponent?, inner: CPComponent?, last: CPComponent?) {
//        saveDividerPositions();

        firstComponent = first
        innerComponent = inner
        lastComponent = last

        //        restoreDividerPositions();
    }

    private fun restoreDividerPositions() {
        println("Restoring $firstSizeProperty, $lastSizeProperty")
    }

    private fun saveDividerPositions() {
        println("Saving $firstSizeProperty, $lastSizeProperty")
    }

    override var firstSize: Double by firstSizeProperty

    override var lastSize: Double by lastSizeProperty

    override val firstSizeIfVisible: Double
        get() = if (firstVisible()) firstSize else 0.0

    override val lastSizeIfVisible: Double
        get() = if (lastVisible()) lastSize else 0.0

    override fun setWidgetHidden(widget: CPComponent?, hidden: Boolean) {
    }

    override fun setShowDividerControls(show: Boolean) {
        showDividerControls.value = show
    }

    private fun firstVisible(): Boolean {
        return firstComponent != null
    }

    private fun lastVisible(): Boolean {
        return lastComponent != null
    }

    private fun innerVisible(): Boolean {
        return innerComponent != null
    }

    private fun visibleDividersCount(): Int {
        var count = 0
        if (firstDividerVisible()) count++
        if (lastDividerVisible()) count++
        return count
    }

    private fun firstDividerVisible(): Boolean {
        return (firstVisible() && innerVisible()) || (firstVisible() && lastVisible() && !innerVisible())
    }

    private fun lastDividerVisible(): Boolean {
        return innerVisible() && lastVisible()
    }
}
