package com.macrofocus.docking.js

import js.objects.unsafeJso
import org.mkui.component.CPComponent
import react.FC
import react.Props
import react.dom.html.ReactHTML
import web.cssom.BackgroundColor
import web.cssom.Position
import web.cssom.pct

external interface FillerProps : Props {
    var backgroundColor: BackgroundColor
}

val Filler = FC<FillerProps> { props ->
    ReactHTML.div {
        style = unsafeJso {
            width = 100.pct
            height = 100.pct
            position = Position.relative
            this.backgroundColor = props.backgroundColor
        }
    }
}

class CPFiller constructor(backgroundColor: BackgroundColor) : CPComponent {
    override val nativeComponent: FC<*> = FC<Props> { props ->
        Filler {
            this.backgroundColor = backgroundColor
        }
    }
}