package com.macrofocus.docking.js

import com.macrofocus.common.command.Command
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.SimpleProperty
import com.macrofocus.docking.DockingAnchor
import js.objects.unsafeJso
import org.mkui.component.CPComponent
import org.mkui.react.toState
import react.FC
import react.Props
import react.dom.html.ReactHTML.div
import web.cssom.*

class DockingButton(orientation: DockingAnchor, command: MutableProperty<Command?> = SimpleProperty(null), private val textProperty: MutableProperty<String?> = SimpleProperty("")) : CPComponent {
    val selectedProperty : MutableProperty<Boolean> = SimpleProperty(false)

    var text by textProperty
    var command by command
    var selected by selectedProperty

    override val nativeComponent: FC<*> = FC<Props> { props ->
        val (getText, _) = textProperty.toState()
        val (getSelected, _) = selectedProperty.toState()

        div {
            className = ClassName("DockingTab")

            style = unsafeJso {
                if(orientation == DockingAnchor.TOP || orientation == DockingAnchor.BOTTOM) {
                    paddingLeft = 6.px
                    paddingRight = 6.px
                } else {
                    paddingLeft = 3.px
                    paddingRight = 3.px
                }
                paddingTop = 3.px
                if(orientation == DockingAnchor.LEFT || orientation == DockingAnchor.RIGHT) {
                    paddingTop = 6.px
                    paddingBottom = 6.px
                } else {
                    paddingTop = 3.px
                    paddingBottom = 3.px
                }

                if(getSelected) {
                    background = rgb(230, 230, 230)

                    if(orientation == DockingAnchor.TOP) {
                        borderTop = Border(2.px, LineStyle.solid, NamedColor.black)
                    } else if(orientation == DockingAnchor.BOTTOM) {
                        borderBottom = Border(2.px, LineStyle.solid, NamedColor.black)
                    } else if(orientation == DockingAnchor.LEFT) {
                        borderLeft = Border(2.px, LineStyle.solid, NamedColor.black)
                    } else if(orientation == DockingAnchor.RIGHT) {
                        borderRight = Border(2.px, LineStyle.solid, NamedColor.black)
                    }
                } else {
                    background = rgb(255, 255, 255, 0.5)
                }
            }

            div {
                className = ClassName("DockingTabInner")

                div {
                    className = ClassName("DockingButton")

                    style = unsafeJso {
                        if(orientation == DockingAnchor.LEFT) {
                            writingMode = WritingMode.verticalLr
                            transform = rotate(180.deg)
                        } else if(orientation == DockingAnchor.RIGHT) {
                            writingMode = WritingMode.verticalLr
                        }

                        cursor = Cursor.pointer
                        pointerEvents = PointerEvents.all

                        whiteSpace = WhiteSpace.pre
                    }

                    onClick = {
                        selected = !selectedProperty.value
                        command.value?.execute()
                    }

                    if(getText != null)
                        +getText
                }
            }
        }
    }
}