package com.macrofocus.docking.js.react

import react.FC
import react.dom.html.ReactHTML.div
import web.cssom.ClassName

val DockingPanel = FC<DockingPanelProps> { props ->
    div {
        className = ClassName("border-layout")

        div {
            className = ClassName("north")
            props.north?.let { it(this) }
        }
        div {
            className = ClassName("west")
            props.west?.let { it(this) }
        }
        div {
            className = ClassName("center")
            props.center?.let { it(this) }
        }
        div {
            className = ClassName("east")
            props.east?.let { it(this) }
        }
        div {
            className = ClassName("south")
            props.south?.let { it(this) }
        }
    }
}