package com.macrofocus.docking.js.react

import react.ChildrenBuilder
import react.FC
import react.Props
import react.dom.html.ReactHTML.div
import react.dom.html.ReactHTML.h3
import web.cssom.ClassName

fun ChildrenBuilder.panel(icon: String, title: String, content: ChildrenBuilder.() -> Unit) {
    Panel {
        this.icon = icon
        this.title = title
        this.content = content
    }
}

external interface PanelProps : Props {
    var icon: String
    var title: String
    var content: (ChildrenBuilder) -> Unit
}

val Panel = FC<PanelProps> { props ->
    div {
        className = ClassName("panel")
        h3 {
            +("${props.icon} ${props.title}")
        }
        div {
            props.content(this)
        }
    }
}