/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking

interface DockingBar<C> {
    fun attach(dockable: Dockable<C>)
    fun detach(dockable: Dockable<C>)
    fun removeAll()
    fun isActive(dockable: Dockable<C>): Boolean
    fun setActive(dockable: Dockable<C>, active: Boolean)
    fun setFloating(dockable: Dockable<C>, floating: Boolean)
    fun setSliding(dockable: Dockable<C>, sliding: Boolean)
    val dockables: List<Dockable<C>?>?
    fun dispose()
    val nativeComponent: C
}