/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing

//import de.javasoft.docking.JYDockingPort
import de.javasoft.docking.JYDockingPort
import de.javasoft.docking.controls.*
import java.util.ArrayList
import javax.swing.Icon
import javax.swing.JComponent

class DockableComponentWrapper(
    paramJComponent: JComponent,
    paramString1: String?,
    paramString2: String?,
    paramBoolean: Boolean
) : IDockable, IDockingConstants {
    private val component: JComponent
    private val id: String
    protected var dragSources: ArrayList<JComponent?>
    protected var dockingListeners: ArrayList<IDockingEventListener?>
    private var dockingEnabled = false
    private var active = false
    private var activeStateLocked = false
    private var tabText: String? = null
    private var dockbarIcon: Icon? = null
    private var tabIcon: Icon? = null
    private var regionInset: HashMap<String?, Float?>? = null
    private var siblingSize: HashMap<String?, Float?>? = null
    private var territoryBlocked: HashMap<String?, Boolean?>? = null
    private var dragThreshold = 0f
    private var previewSize = 0f
    private var mouseMotionListenersBlockedWhileDragging = false
    private var dockableAcceptor: IDockableAcceptor? = null
    private fun initDefaults() {
        dockingEnabled = true
        if (tabText == null) tabText = "-------"
        dragThreshold = 4.0f
        previewSize = 0.3f
        mouseMotionListenersBlockedWhileDragging = true
        regionInset = HashMap<String?, Float?>()
        regionInset!!["NORTH"] = java.lang.Float.valueOf(0.25f)
        regionInset!!["SOUTH"] = java.lang.Float.valueOf(0.25f)
        regionInset!!["EAST"] = java.lang.Float.valueOf(0.25f)
        regionInset!!["WEST"] = java.lang.Float.valueOf(0.25f)
        siblingSize = HashMap<String?, Float?>()
        //        this.siblingSize.put("NORTH", Float.valueOf(DockingManager.getDefaultSiblingSize()));
//        this.siblingSize.put("SOUTH", Float.valueOf(DockingManager.getDefaultSiblingSize()));
//        this.siblingSize.put("EAST", Float.valueOf(DockingManager.getDefaultSiblingSize()));
//        this.siblingSize.put("WEST", Float.valueOf(DockingManager.getDefaultSiblingSize()));
        territoryBlocked = HashMap<String?, Boolean?>()
        territoryBlocked!!["NORTH"] = java.lang.Boolean.FALSE
        territoryBlocked!!["SOUTH"] = java.lang.Boolean.FALSE
        territoryBlocked!!["EAST"] = java.lang.Boolean.FALSE
        territoryBlocked!!["WEST"] = java.lang.Boolean.FALSE
        territoryBlocked!!["CENTER"] = java.lang.Boolean.FALSE
        dockableAcceptor = object : IDockableAcceptor {
            override fun acceptDockable(paramAnonymousIDockable: IDockable?, paramAnonymousString: String?): Boolean {
                val localIDockingPort: IDockingPort = getDockingPort()
                return (localIDockingPort !is JYDockingPort || !(localIDockingPort as JYDockingPort).isRegionBlocked(
                    paramAnonymousString
                )) && !isTerritoryBlocked(paramAnonymousString)
            }
        }
    }

    override fun getComponent(): JComponent {
        return component
    }

    override fun getID(): String {
        return id
    }

    override fun getDockingPort(): IDockingPort {
        return DockingManager.getDockingPort(this)
    }

    override fun getDragSources(): MutableList<JComponent?> {
        return dragSources
    }

    override fun dock(
        paramIDockable: IDockable?,
        paramPerspective: Perspective?,
        paramString: String?,
        paramFloat: Float
    ): Boolean {
//        return DockingManager.dock(paramIDockable, this, paramPerspective, paramString, paramFloat);
        return false
    }

    override fun addDockingListener(paramIDockingEventListener: IDockingEventListener?) {
        dockingListeners.add(paramIDockingEventListener)
    }

    override fun removeDockingListener(paramIDockingEventListener: IDockingEventListener?) {
        dockingListeners.remove(paramIDockingEventListener)
    }

    override fun getDockingListeners(): List<IDockingEventListener?> {
        return dockingListeners
    }

    override fun setDockingEnabled(paramBoolean: Boolean) {
        val bool = isDockingEnabled()
        dockingEnabled = paramBoolean
        component.firePropertyChange("dockingEnabled", bool, paramBoolean)
    }

    override fun isDockingEnabled(): Boolean {
        return dockingEnabled
    }

    override fun setActive(paramBoolean: Boolean) {
        if (!isActiveStateLocked() && paramBoolean != isActive()) {
            val bool = isActive()
            active = paramBoolean
            component.firePropertyChange("active", bool, paramBoolean)
            component.repaint()
        }
    }

    override fun isActive(): Boolean {
        return active
    }

    override fun setActiveStateLocked(paramBoolean: Boolean) {
        val bool = isActiveStateLocked()
        activeStateLocked = paramBoolean
        component.firePropertyChange("activeStateLocked", bool, paramBoolean)
    }

    override fun isActiveStateLocked(): Boolean {
        return activeStateLocked
    }

    override fun setTabText(paramString: String?) {
        tabText = paramString
    }

    override fun getTabText(): String? {
        return tabText
    }

    override fun setDockbarIcon(paramIcon: Icon?) {
        dockbarIcon = paramIcon
    }

    override fun getDockbarIcon(): Icon? {
        return dockbarIcon
    }

    override fun setTabIcon(paramIcon: Icon?) {
        tabIcon = paramIcon
    }

    override fun getTabIcon(): Icon? {
        return tabIcon
    }

    override fun setRegionInset(paramString: String?, paramFloat: Float) {
        regionInset!![paramString] = java.lang.Float.valueOf(paramFloat)
    }

    override fun getRegionInset(paramString: String?): Float {
        val localFloat = regionInset!![paramString]
        return localFloat ?: 0.0f
    }

    override fun setSiblingSize(paramString: String?, paramFloat: Float) {
        siblingSize!![paramString] = java.lang.Float.valueOf(paramFloat)
    }

    override fun getSiblingSize(paramString: String?): Float {
        val localFloat = siblingSize!![paramString]
        return localFloat ?: 0.0f
    }

    override fun setTerritoryBlocked(paramString: String?, paramBoolean: Boolean) {
        territoryBlocked!![paramString] = java.lang.Boolean.valueOf(paramBoolean)
    }

    override fun isTerritoryBlocked(paramString: String?): Boolean {
        val localBoolean = territoryBlocked!![paramString]
        return localBoolean != null && localBoolean
    }

    override fun setDragTheshold(paramFloat: Float) {
        val f = getDragThreshold()
        dragThreshold = paramFloat
        component.firePropertyChange("dragThreshold", f, paramFloat)
    }

    override fun getDragThreshold(): Float {
        return dragThreshold
    }

    override fun setPreviewSize(paramFloat: Float) {
        val f = getPreviewSize()
        previewSize = paramFloat
        component.firePropertyChange("previewSize", f, paramFloat)
    }

    override fun getPreviewSize(): Float {
        return previewSize
    }

    override fun setMouseMotionListenersBlockedWhileDragging(paramBoolean: Boolean) {
        val bool = isMouseMotionListenersBlockedWhileDragging()
        mouseMotionListenersBlockedWhileDragging = paramBoolean
        component.firePropertyChange("mouseMotionListenersBlockedWhileDragging", bool, paramBoolean)
    }

    override fun isMouseMotionListenersBlockedWhileDragging(): Boolean {
        return mouseMotionListenersBlockedWhileDragging
    }

    override fun setDockableAcceptor(paramIDockableAcceptor: IDockableAcceptor?) {
        dockableAcceptor = paramIDockableAcceptor
    }

    override fun getDockableAcceptor(): IDockableAcceptor? {
        return dockableAcceptor
    }

    override fun dockableRegistered(paramDockingEvent: DockingEvent?) {}
    override fun dockableUnregistered(paramDockingEvent: DockingEvent?) {}
    override fun dockingCanceled(paramDockingEvent: DockingEvent?) {}
    override fun dockingCompleted(paramDockingEvent: DockingEvent?) {}
    override fun dragStarted(paramDockingEvent: DockingEvent?) {}
    override fun dropStarted(paramDockingEvent: DockingEvent?) {}
    override fun undockingStarted(paramDockingEvent: DockingEvent?) {}
    override fun undockingCompleted(paramDockingEvent: DockingEvent?) {}

    init {
        requireNotNull(paramString1) { "The 'id' parameter cannot be null." }
        component = paramJComponent
        id = paramString1
        setTabText(paramString2)
        dragSources = ArrayList<JComponent?>(1)
        dockingListeners = ArrayList<IDockingEventListener?>(1)
        initDefaults()
        if (paramBoolean) getDragSources().add(paramJComponent)
    }
}