/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing

import com.macrofocus.common.helper.LookAndFeelHelper
import com.macrofocus.docking.DockingAnchor
import com.macrofocus.docking.swing.plaf.DockingButtonUI
import com.macrofocus.docking.swing.plaf.metal.MetalDockingButtonUI
import com.macrofocus.docking.swing.plaf.synth.SynthDockingButtonUI
import java.awt.Color
import javax.swing.BorderFactory
import javax.swing.JToggleButton
import javax.swing.UIManager
import javax.swing.border.Border

/**
 * User: luc
 * Date: May 31, 2006
 * Time: 10:55:27 PM
 */
class DockingButton(orientation: DockingAnchor) : JToggleButton() {
    private val orientation: DockingAnchor
    val mnemonic2 = 0
    override fun updateUI() {
        if (UIManager.get(uIClassID) != null) {
            uI = UIManager.getUI(this) as DockingButtonUI
        } else {
            if (LookAndFeelHelper.isSynth) {
                uI = SynthDockingButtonUI()
            } else {
                uI = MetalDockingButtonUI()
            }
        }
    }

    var uI: DockingButtonUI
        get() = ui as DockingButtonUI
        set(ui) {
            super.setUI(ui)
        }

    fun getOrientation(): DockingAnchor {
        return orientation
    }

    private val a = Color(247, 243, 239)

    companion object {
        val uIClassID = "DockingButtonUI"
    }

    init {
        this.orientation = orientation
        setFocusable(false)
        setBackground(a)
        val border: Border = BorderFactory.createEmptyBorder(5, 5, 0, 5)
        setBorder(border)
        //        updateText();
//        updateState();
//        apply(c.getWindowInfo());
//        c.getToolWindow().addPropertyChangeListener(d);
//        addActionListener(this);
//        addMouseListener(new MyPopupHandler());
        setRolloverEnabled(true)
        setOpaque(false)
        //        enableEvents(16L);
        updateUI()
    }
}