/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing

import com.macrofocus.docking.swing.plaf.DockingViewContentPaneUI
import org.jdesktop.swingx.plaf.LookAndFeelAddons
import java.awt.BorderLayout
import javax.swing.JPanel

class DockingViewContentPane : JPanel(BorderLayout()) {
    override fun getUIClassID(): String {
        return "DockingViewContentPaneUI"
    }

    override fun updateUI() {
        setUI(LookAndFeelAddons.getUI(this, DockingViewContentPaneUI::class.java))
    }

    override fun getUI(): DockingViewContentPaneUI {
        return this.ui as DockingViewContentPaneUI
    }

    companion object {
        private const val serialVersionUID = 8781589092249213482L
        const val uiClassID = "DockingViewContentPaneUI"
    }

    init {
        setName("JYDocking.dockingView.contentPane")
    }
}