/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing

import com.macrofocus.docking.swing.plaf.DockingViewTitleBarUI
import com.macrofocus.docking.swing.plaf.basic.BasicDockingViewTitleBarUI
import de.javasoft.docking.ui.controls.IDockingButtonFactory
import org.jdesktop.swingx.plaf.LookAndFeelAddons
import java.awt.Color
import java.awt.Dimension
import java.awt.Font
import javax.swing.*

class DockingViewTitleBar @JvmOverloads constructor(
    paramString: String? = null,
    paramArrayOfAction: Array<Action?>? = null
) : JComponent() {
    private val titleLabel: JLabel
    private var titleForeground: Color? = null
    private var activeTitleForeground: Color? = null
    private var dockingButtons: LinkedHashMap<Action?, DockingButton?>? = null
    private var parentView: DockingView? = null
    override fun getUIClassID(): String {
        return "DockingViewTitleBarUI"
    }

    override fun updateUI() {
        setUI(LookAndFeelAddons.getUI(this, DockingViewTitleBarUI::class.java))
    }

    override fun getUI(): DockingViewTitleBarUI {
        return this.ui as DockingViewTitleBarUI
    }

    protected fun setActions(paramArrayOfAction: Array<Action?>?) {
        var paramArrayOfAction = paramArrayOfAction
        if (paramArrayOfAction == null) {
            paramArrayOfAction = arrayOfNulls(0)
            dockingButtons = LinkedHashMap<Action?, DockingButton?>(4)
        }
        removeActions()
        for (i in paramArrayOfAction.indices) addAction(paramArrayOfAction[i])
    }

    protected fun removeActions() {
        for (localAction in getActions()) removeAction(localAction)
    }

    fun getActions(): Array<Action?> {
        return dockingButtons!!.keys.toTypedArray()
    }

    fun addAction(paramAction: Action?) {
        if (!dockingButtons!!.keys.contains(paramAction)) {
            val localDockingButton = createDockingButton(paramAction)
            dockingButtons!![paramAction] = localDockingButton
            add(localDockingButton)
        }
    }

    fun removeAction(paramAction: Action?) {
        if (dockingButtons!!.keys.contains(paramAction)) {
            remove(dockingButtons!![paramAction])
            dockingButtons!!.remove(paramAction)
        }
    }

    fun isActive(): Boolean {
        return parentView != null && parentView!!.isActive
    }

    fun setView(paramJYDockingView: DockingView?) {
        parentView = paramJYDockingView
    }

    fun getView(): DockingView {
        return SwingUtilities.getAncestorOfClass(DockingView::class.java, this) as DockingView
    }

    private fun createDockingButton(paramAction: Action?): DockingButton? {
        val localDockingButton: DockingButton? = null
        val localIDockingButtonFactory: IDockingButtonFactory =
            (getUI() as BasicDockingViewTitleBarUI).getDockingButtonFactory()!!

//        if ((paramAction instanceof DefaultMinimizeAction))
//            localDockingButton = localIDockingButtonFactory.createMinimizeButton(paramAction);
//        else if ((paramAction instanceof DefaultMaximizeAction))
//            localDockingButton = localIDockingButtonFactory.createMaximizeButton(paramAction);
//        else if ((paramAction instanceof DefaultFloatAction))
//            localDockingButton = localIDockingButtonFactory.createFloatButton(paramAction);
//        else if ((paramAction instanceof DefaultCloseAction)) {
//            localDockingButton = localIDockingButtonFactory.createCloseButton(paramAction);
//        }
//
//        if ((paramAction instanceof AbstractDockingViewAction))
//        {
//            ButtonModel localButtonModel = ((AbstractDockingViewAction)paramAction).createButtonModel();
//            if (localButtonModel != null)
//                localDockingButton.setModel(localButtonModel);
//        }
        return localDockingButton
    }

    fun setTitleText(paramString: String?) {
        titleLabel.setText(paramString ?: "")
    }

    fun getTitleText(): String {
        return titleLabel.getText()
    }

    fun getTitleIcon(): Icon {
        return titleLabel.getIcon()
    }

    fun setTitleIcon(paramIcon: Icon?) {
        titleLabel.setIcon(paramIcon)
    }

    fun setTitleForeground(paramColor: Color?) {
        titleForeground = paramColor
    }

    fun getTitleForeground(): Color? {
        return titleForeground
    }

    fun setActiveTitleForeground(paramColor: Color?) {
        activeTitleForeground = paramColor
    }

    fun getActiveTitleForeground(): Color? {
        return activeTitleForeground
    }

    protected fun getIcon(paramAction: Action?): Icon? {
        val localObject = paramAction?.getValue("SmallIcon")
        return if (localObject is Icon) localObject else null
    }

    private inner class TitleLabel : JLabel() {
        override fun getMinimumSize(): Dimension {
            val i = if (getIcon() == null) 0 else getIcon()!!.iconWidth
            return Dimension(i, super.getMinimumSize().height)
        }

        override fun getForeground(): Color? {
            return if (isActive()) getActiveTitleForeground() else getTitleForeground()
        }

//        override fun getFont(): Font {
//            return getFont()
//        }

        override fun isFocusable(): Boolean {
            return false
        }

//        companion object {
//            private const val serialVersionUID = -1108225465058579891L
//        }
    }

    companion object {
        private const val serialVersionUID = -8936591064762821423L
        const val uiClassID = "DockingViewTitleBarUI"
    }

    init {
        titleLabel = TitleLabel()
        setTitleText(paramString)
        setActions(paramArrayOfAction)
        add(titleLabel)
        add(Box.createHorizontalGlue())
        updateUI()
    }
}